/*
 * Decompiled with CFR 0.152.
 */
package panther.program;

import java.net.ServerSocket;
import java.net.Socket;
import panther.client.LogManager;
import panther.client.Logable;
import panther.program.MarvelIipRequestProcessor;
import pse.util.general.ErrorUtils;

public class MarvelIipServer
extends Thread {
    protected ServerSocket serverSocket;
    protected LogManager logManager = new LogManager();
    protected boolean shouldStop = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.serverSocket = new ServerSocket(40000);
        }
        catch (Throwable throwable) {
            ErrorUtils.checkIgnore(throwable);
            this.logManager.log("Unable to start MarvelIipServer due to following error: " + throwable);
        }
        while (!this.shouldStop) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                this.logManager.log("PSE/Marvel Integration");
                MarvelIipRequestProcessor marvelIipRequestProcessor = new MarvelIipRequestProcessor(socket, this.logManager);
                marvelIipRequestProcessor.process();
                this.logManager.log("PSE/Marvel Integrator - End");
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                ErrorUtils.checkIgnore(throwable);
                this.logManager.log("Error in MarvelIipServer " + throwable.getMessage());
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    ErrorUtils.checkIgnore(throwable);
                }
                socket = null;
            }
        }
        if (this.serverSocket == null) return;
        try {
            this.serverSocket.close();
            return;
        }
        catch (Throwable throwable) {
            ErrorUtils.checkIgnore(throwable);
        }
    }

    public void interrupt() {
        this.shouldStop = true;
        super.interrupt();
    }

    public void register(Logable logable) {
        this.logManager.register(logable);
    }

    public static void main(String[] stringArray) throws Exception {
        MarvelIipServer marvelIipServer = new MarvelIipServer();
        marvelIipServer.start();
    }
}

